
// This scilab code is used to perform different edge detection methods on images 
//which can be used in shape analysis.

//The scilab environment for this is : Scilab 6.0.1

//Toolbox used: Image Processing and Computer Vision Toolbox ver. 1.1
              

//OS used : Windows 10 64 bit
// 
//Reference book name : Digital Image Processing
//book author: Rafael C. Gonzalez and Richard E. Woods

//clc //to clear command window.
//clear all //to kill previously defined variables.
//xdel(winsid())//to close all currently open figure(s).

//This code uses shapes.jpg image file for processing


img = imread('shapes.jpg');                         // Reads input image shapes.jpg
img = rgb2gray(img);                                // Converts input image to gray scale
clf                                                 // Clears figure handle
imshow(img);                                        // Show gray scale image (Result file exp_9_1_result_1.png)

e = edge(img);                                      // This performs edge detection operation with sobel, thresh = 0.5
figure(2);                                          // Opens new figure
imshow(e)                                           // Show result image (Result file exp_9_1_result_2.png)

e = edge(img, 'prewitt'); // thresh = 0.5           // Applied prewitt edge detection method
figure(3);
imshow(e)                                           // Show result image (Result file exp_9_1_result_3.png)

e = edge(img, 'canny', [0.06  0.2]);                // Applies canny edge detection method
figure(4);
imshow(e)                                           // Show result image (Result file exp_9_1_result_4.png)

e = edge(img, 'fftderiv', 0.4);                     // Applies FFT gradient method; 0.4 threshold
figure(5);
imshow(e)                                           // Show result image (Result file exp_9_1_result_5.png)

